'****************************************************************
'*  Name    : Pl Codierer fr Platine V2.0                     *
'*  Version : 2.4 fr PIC18F252                                 *
'*  Date    : 13.01.2006                                        *
'*  Author  : Bernd Rter, Hannover                             *
'*  Notice  : Copyright (c) 2006 Promaxx, Hannover              *
'*          : All Rights Reserved                               *
'*  Changelog:                                                  *
'*   2.1    : Zahlenwerte erweitert (Umrechnung & neg. Werte)   *
'*            Fix: Level_Mask wird bei altem Protokoll gelscht.*
'*   2.2    : Komma bei Zahlenwerten unter 1 soll jetzt passen. *
'*   2.3    : Hnger bei der Anzeige von Zahlen endlich behoben.*
'*   2.4    : Und wieder die Zahlenanzeige gefixed.             *
'****************************************************************

DEFINE          OSC 4
INCLUDE         "modedefs.bas"
DEFINE NO_CLRWDT 1
@ __CONFIG    _CONFIG1H, _OSCS_OFF_1H & _XT_OSC_1H
@ __CONFIG    _CONFIG2L, _BOR_ON_2L & _PWRT_ON_2L & _BORV_42_2L
@ __CONFIG    _CONFIG2H, _WDT_OFF_2H & _WDTPS_128_2H
@ __CONFIG    _CONFIG3H, _CCP2MX_ON_3H
@ __CONFIG    _CONFIG4L, _STVR_ON_4L & _LVP_OFF_4L & _DEBUG_OFF_4L
@ __CONFIG    _CONFIG5L, _CP0_ON_5L & _CP1_ON_5L & _CP2_ON_5L & _CP3_ON_5L
@ __CONFIG    _CONFIG5H, _CPB_OFF_5H & _CPD_OFF_5H
@ __CONFIG    _CONFIG6L, _WRT0_OFF_6L & _WRT1_OFF_6L & _WRT2_OFF_6L & _WRT3_OFF_6L
@ __CONFIG    _CONFIG6H, _WRTC_ON_6H & _WRTB_ON_6H & _WRTD_OFF_6H
@ __CONFIG    _CONFIG7L, _EBTR0_OFF_7L & _EBTR1_OFF_7L & _EBTR2_OFF_7L & _EBTR3_OFF_7L
@ __CONFIG    _CONFIG7H, _EBTRB_OFF_7H

LCD_Len         CON 16
Cod_Len         CON 16
I2C_In_n        CON LCD_Len*4+10
I2C_Out_n       CON 17

'IC-Interface
I2C_Cod         CON $10
SCL             VAR PortC.3
SDA             VAR PortC.4

' Define used register flags
SSPIE           VAR PIE1.3          ' SSP (I2C) interrupt enable (IE)
SSPIF           VAR PIR1.3          ' SSP (I2C) interrupt flag
SSP_BF          VAR SSPSTAT.0       ' SSP (I2C) Buffer Full
SSP_R_W         VAR SSPSTAT.2       ' SSP (I2C) Read/Write
SSP_D_A         VAR SSPSTAT.5       ' SSP (I2C) Data/Address
SSP_CKP         VAR SSPCON1.4       ' SSP (I2C) SCK Release Control
SSPEN           VAR SSPCON1.5       ' SSP (I2C) Enable
SSPOV           VAR SSPCON1.6       ' SSP (I2C) Receive Overflow Indicator
SSP_WCOL        VAR SSPCON1.7       ' SSP (I2C) Write Collision Detect

'ICSP-Interface
'Data           VAR PortB.7
'Clk            VAR PortB.6

;Hardware-Bits
GIE             VAR INTCON.7
PEIE            VAR INTCON.6
RBPU_           VAR INTCON2.7
RBIF            VAR INTCON.0
RBIE            VAR INTCON.3
INT0IF          VAR INTCON.1
INT0IE          VAR INTCON.4
INTEDG0         VAR INTCON2.6
TMR1IF          VAR PIR1.0
TMR1IE          VAR PIE1.0
TMR3IF          VAR PIR2.1
TMR3IE          VAR PIE2.1
TMR1ON          VAR T1CON.0
TMR3ON          VAR T3CON.0
RCIF            VAR PIR1.5
TXIF            VAR PIR1.4
RCIE            VAR PIE1.5
FERR            VAR RCSTA.2
OERR            VAR RCSTA.1
CREN            VAR RCSTA.4
TRMT            VAR TXSTA.1
Warte_Timer1    CON 12500^$FFFF     ;100ms Sekunde @ 4MHz, Prescaler=8
Ct_10tel        VAR Byte BANKA      ;1/10-Sekunden Zhler
Ct_3tel         VAR Byte BANKA      ;1/3-Sekunden Zhler (Repeat)
;Belegungen der TRIS-Register fr Matrix-Abfrage
TRISB_Normal    CON %11110000
TRISB_Reverse   CON %00001100

'Buffer
I2C_In_Ct       Var Byte BANKA
I2C_In          VAR Byte[I2C_In_n]
I2C_In_1        Var I2C_In[1]
I2C_In_2        Var I2C_In[2]
I2C_In_3        Var I2C_In[3]
I2C_In_4        Var I2C_In[4]
I2C_In_5        Var I2C_In[5]
I2C_Out_Ct      Var Byte BANKA
I2C_Out         VAR Byte[I2C_Out_n]
I2C_Out_0       VAR I2C_Out[0]      ;1. Byte = Status
                           
;div.                   


;==========================================================================
define  INTHAND IntServ

;==========================================================================
;Start - Hardware initialisieren
;==========================================================================
Init:
'Initialize I2C slave mode
    Input SCL:Input SDA
    SSPADD = I2C_Cod 		' Set our address
    SSPCON1 = %00110110		' Set to I2C slave with 7-bit address
    SSPCON2 = 0
'Status lschen
    I2C_Out_0=0:Cod_Online=1:Cod_V2=1
'FIFO initialisieren
    I2C_In_Ct=0


'Interrupt aktivieren            
    SSPIF=0:SSPIE=1:PEIE=1:GIE=1


;==========================================================================
;Befehle von der Steuerung abarbeiten - Endlosschleife
;==========================================================================
Main:
    Pause 100
;I2C abarbeiten
    If I2C_In_Ct Then
        Dummy_Bit=0
        Dummy=I2C_In & %11110000
        ;Steuerung ab 3.5 aber nicht fehlerfrei
        If Dummy=$A0 Then Flag_FormatV2=0:Dummy_Bit=1
        ;Steuerung ab PL-S 3.6
        If Dummy=$B0 Then Flag_FormatV2=1:Dummy_Bit=1
        If Dummy_Bit Then
            Flag_GetFlags=1                             ;Codierung auslesen merken
            Buf_Cod_Len=I2C_In&$0F
            For I=0 to Buf_Cod_Len-1:Buf_Cod[I]=0:Next I
            Repeat
            Until I2C_In_Ct>=3                          ;Anzahl Bytes abwarten
            Repeat
            Until I2C_In_Ct>=I2C_In_2+3                 ;ID abwarten
            For I=0 to I2C_In_2-1:Buf_ID[I]=I2C_In_3[I]:Next I ;ID-Text kopieren
        Endif
        ;alte Steuerung
        If Dummy=$90 Then
            Flag_GetFlags=0:Flag_FormatV2=0
            Buf_Cod_Len=(I2C_In & %00001111)>>1
            For I=0 to Buf_Cod_Len-1:Buf_Cod[I]=0:Next I
            Dummy_Bit=1
        Endif

        I2C_In_Ct=0 ;I2C lschen
        If Dummy_Bit Then        



        Endif
    Endif
    Goto Main       ;Loop
End



;==========================================================================
;INT-Handler
;==========================================================================
asm
IntServ

;==========================================================================
;INT aus SSP = IC ?
;==========================================================================
Srv_I2C
    btfss _SSPIF
    goto  Srv_I2C_E
    ;ja, IF lschen
    bcf   _SSPIF

;IC Lesen oder Schreiben ?
    btfsc _SSP_R_W          ;Read/Write ?
    goto  Srv_I2C_RD        ;-> Read

Srv_I2C_WR
;IC Write from Master   
    btfss _SSP_BF           ;Buffer empty ?
    goto  Srv_I2C_Err       ;-> Fehler, ignorieren
    btfsc _SSP_D_A          ;Data ?
    goto Srv_I2C_WR1        ;ja -> Folgebytes
Srv_I2C_WR0
Srv_I2C_Err
    MOVF SSPBUF,W           ;I2C-Buffer leeren
    bsf _SSP_CKP
    goto IntServE
    
Srv_I2C_WR1
    movff FSR0L,_ZW_Srv_L   ;FSR0 sichern
    movff FSR0H,_ZW_Srv_H
    movlw low(_I2C_In)      ;Adresse in Buffer berechnen
    addwf _I2C_In_Ct,w      ;und im FSR ablegen
    movwf FSR0L
    movlw high(_I2C_In)
    movwf FSR0H
    bnc Srv_I2C_WR1_1
    incf FSR0H

Srv_I2C_WR1_1    
    movf SSPBUF,w           ;I2C-Buffer auslesen

    movwf INDF0             ;Zeichen abspeichern
    bcf _SSPOV              ;OV-Err zur Sicherheit lschen
    movff _ZW_Srv_L,FSR0L   ;FSR0 restaurieren
    movff _ZW_Srv_H,FSR0H
    incf _I2C_In_Ct,f       ;Counter erhhen
    movlw _I2C_In_n         ;max
    cpfslt _I2C_In_Ct       ;erreicht ?
    decf _I2C_In_Ct         ;zuviel, 1 zurck
    bcf _Cod_GetTxt         ;Flags lschen, Daten kommen jetzt
    bcf _Cod_GetFlags
    goto IntServE
    
;IC Read from Master
Srv_I2C_RD
    btfsc SSPSTAT,BF        ;noch voll ?
    goto Srv_I2C_RD         ;ja -> Loop
    btfsc SSPSTAT,D_A       ;Data ?
    goto Srv_I2C_RD1        ;ja -> Folgebytes
;erstes Byte lesen
Srv_I2C_RD0
    clrf _I2C_Out_Ct        ;Zhler lschen
;Folgebytes lesen    
Srv_I2C_RD1
    movff FSR0L,_ZW_Srv_L   ;FSR0 sichern
    movff FSR0H,_ZW_Srv_H
    movlw low(_I2C_Out)     ;Adresse in Buffer berechnen
    addwf _I2C_Out_Ct,w     ;und im FSR ablegen
    movwf FSR0L
    movlw high(_I2C_Out)
    movwf FSR0H
    bnc Srv_I2C_RD1_1
    incf FSR0H
Srv_I2C_RD1_1    
    movf INDF0,w            ;I2C-Buffer auslesen
Srv_I2C_RD1L
    bcf _SSP_WCOL           ;Collision lschen
    movwf SSPBUF            ;Zeichen senden
    btfsc _SSP_WCOL         ;Collision aufgetreten ?
    goto Srv_I2C_RD1L       ;ja, Neu versuchen
    bsf _SSP_CKP
    incf _I2C_Out_Ct,f      ;Counter erhhen
    movff _ZW_Srv_L,FSR0L   ;FSR0 restaurieren
    movff _ZW_Srv_H,FSR0H
Srv_I2C_E    
endasm


asm
;==========================================================================
;Int Exit
;==========================================================================
IntServE
    retfie 1
endasm
